package gov.va.med.mhv.sm.web.form;

import gov.va.med.mhv.sm.enumeration.ParticipantTypeEnum;
import gov.va.med.mhv.sm.model.Surrogate;
import gov.va.med.mhv.sm.util.DateUtils;

import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;

public class AssignSurrogates {

	private String id;
	private String staffOrTriageStr;
	private String startDate;
	private String startTime;
	private String endDate;
	private String endTime;
	private String allDay = "false";
	private ParticipantTypeEnum surrogateType;
	
	public AssignSurrogates(){}
	
	public String getAllDay() {
		return allDay;
	}
	public void setAllDay(String allDay) {
		this.allDay = allDay;
	}
	
	public void setAllDayBool(boolean allDay) {
		this.allDay = Boolean.toString(allDay);
	}
	public boolean getAllDayBool() {
		return this.allDay.equalsIgnoreCase("true")||this.allDay.equalsIgnoreCase("on");
	}
	
	public String getEndDate() {
		return endDate;
	}
	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}
	public String getEndTime() {
		return endTime;
	}
	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}
	//ID is in the form "1|{id}" or "2|{id}"
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getStartDate() {
		return startDate;
	}
	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}
	public String getStartTime() {
		return startTime;
	}
	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

	public Date getEndDateTime() throws ParseException {
		return DateUtils.parseFullDateTime(getEndDate()+" "+ getEndTime());
	}

	public Date getStartDateTime() throws ParseException {
		return DateUtils.parseFullDateTime(getStartDate()+" "+ getStartTime());
	}

	public void setStaffOrTriageValue(String staffOrTriageStr) {
		this.staffOrTriageStr = staffOrTriageStr;
	}
	
	public String getStaffOrTriageValue() {
		return this.staffOrTriageStr;
	}
	
	public ParticipantTypeEnum getSurrogateType() {
		if( surrogateType == null && id != null ) {
			if( id.startsWith(StaffOrTriageVO.CLINICIAN_TYPE) ) {
				surrogateType = ParticipantTypeEnum.CLINICIAN;
			} else if( id.startsWith(StaffOrTriageVO.TRIAGE_GROUP_TYPE) ) {
				surrogateType = ParticipantTypeEnum.TRIAGE_GROUP;
			}
		}
		return surrogateType;
	}

	public void setSurrogateType(ParticipantTypeEnum surrogateType) {
		this.surrogateType = surrogateType;
	}
	
	public Long getSurrogateId() {
		return Long.parseLong(id.substring(2));
	}

	public static AssignSurrogates createAssignSurrogate( Surrogate surrogate ) {
		AssignSurrogates a = new AssignSurrogates();
		
		//surrogateType will be null for default surrogate rows
		if( surrogate.getSurrogateType() != null ) {
			if( surrogate.getSurrogateType().equals(ParticipantTypeEnum.CLINICIAN) ) {
				a.setId(StaffOrTriageVO.CLINICIAN_TYPE + surrogate.getSurrogateId());
			} else if( surrogate.getSurrogateType().equals(ParticipantTypeEnum.TRIAGE_GROUP) ) {
				a.setId(StaffOrTriageVO.TRIAGE_GROUP_TYPE + surrogate.getSurrogateId());
			}
		}
		
		a.setAllDayBool(surrogate.isSurrogateAllDay());
		a.setStartDate(trimLeadingZero(DateUtils.getEnglishDate(surrogate.getSurrogateStartDate())));
		a.setEndDate(trimLeadingZero(DateUtils.getEnglishDate(surrogate.getSurrogateEndDate())));
		a.setStartTime(trimLeadingZero(DateUtils.getEnglishTime(surrogate.getSurrogateStartDate())));
		a.setEndTime(trimLeadingZero(DateUtils.getEnglishTime(surrogate.getSurrogateEndDate())));
		a.setSurrogateType(surrogate.getSurrogateType());
		return a;
	}
	
	private static String trimLeadingZero(String time) {
		if(time.startsWith("0"))
			return time.substring(1);
		return time;
	}
	
	public static final Comparator<AssignSurrogates> ASSIGN_SURROGATES_SORTER = new Comparator<AssignSurrogates>() {
		public int compare(AssignSurrogates a, AssignSurrogates b) {
			Date a1;
			Date b1;
			try {
				a1 = a.getStartDateTime();
				b1 = b.getStartDateTime();
			} catch (ParseException e) {
				return 0;
			}
			if(a1 == null || b1 == null) return 0;
			return a1.compareTo(b1);
		}
	};
	
}
